<?php
	$title = "PageRank Lookup - Optimization";
	require "structures/header.php";
	require "php/pagerank.php";
	
	function isValidURL($url) {
		return preg_match('|^http(s)?://[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$|i', $url);
	}
	
	$done = false;
	$error = "";
	
	if(isset($_POST['url'])) {
		$url = trim($_POST['url']);
		
		if(!isValidURL($url)) {
			$error = "<strong>Well, great job.</strong> You managed to mess up the URL too. Please enter a valid website URL.";
		}
		else {
			$pageRank = GooglePageRankChecker::getRank(@$url);
			$pageRank = intval($pageRank);
			if($pageRank > 9) $pageRank = 9; // bug identified; twitter.com produces pagerank of 10 for some odd reason; google stays at 9; FIXED
			
			$percent = ceil(($pageRank / 9) * 100);
		}
		
		$done = true;
	}
?>

<div class="span9">
	<ul class="breadcrumb">
		<li><a href="index.php">Home</a> <span class="divider">/</span></li>
		<li><a href="tools.php">Tools</a> <span class="divider">/</span></li>
		<li><a href="tools-optimization.php">Optimization</a> <span class="divider">/</span></li>
		<li class="active">PageRank Lookup</li>
	</ul>
	
	<div class="page-header">
		<h2>PageRank Lookup</h2>
	</div>
	
	<div class="row" style="margin-left: 0px;">
		<div class="col-md-12">
			<div class="well">
				<form action="pagerank-lookup.php" method="POST" style="margin: 0px;">
					<div class="input-group">
						<input type="text" class="form-control input-lg" name="url" value="<?=$headers->PostField('url');?>" placeholder="http://www.google.com/">
						<span class="input-group-btn">
							<input class="btn btn-success btn-lg" type="submit" value="Lookup">
						</span>
					</div>
				</form>
			</div>
		</div>
	</div>
	
	<?php if($done == true) { ?>
		<?php if($error != "") { ?><div class="alert alert-error"><?=$error;?></div><?php } else { ?>
	
		<div class="row" style="margin-left: 0px;">
			<div class="col-md-12">
				<div class="well">
					<b><?=$_POST['url'];?></b> has a PageRank of <?=$pageRank;?>.
					<?php
                        if($pageRank == 0) {
                            echo "The website might not be getting enough exposure or backlinks.";
                        }
                    ?>
				</div>
			</div>
			<div class="span6">
			</div>
		</div>
		
		<?php } ?>
	<?php } ?>
</div>
	
<?php
	require "structures/footer.php";
?>